/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.queue;

import filenet.vw.api.VWException;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.queue.VWNewWorkBasketWizard;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.wizard.IVWWizardPanel;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class VWWorkBasketGeneralWizardPanel
extends JPanel
implements IVWWizardPanel {
    private VWNewWorkBasketWizard m_workBasketWizard = null;
    private VWQueueDefinition m_selectedQueueDef = null;
    private VWWorkBasketDefinition m_workBasketDef = null;
    private JTextField m_nameTextField = null;
    private JComboBox m_queueComboBox = null;
    private JTextArea m_descriptionTextArea = null;

    public VWWorkBasketGeneralWizardPanel(VWNewWorkBasketWizard workBasketWizard, VWQueueDefinition[] queueDefs) {
        this.m_workBasketWizard = workBasketWizard;
        this.createControls(queueDefs);
    }

    public void checkForErrors() throws Exception {
        this.createWorkBasket();
    }

    public String getHelpTopic() {
        return "queue_selection";
    }

    public String getUniqueIdentifier() {
        return "QUEUE_SELECTION";
    }

    public String getInstructions() {
        return VWResource.QueueSelectionPanelInstructions;
    }

    public String getTitle() {
        return VWResource.QueueSelectionPanelTitle;
    }

    public void initialize() throws Exception {
    }

    public void releaseResources() {
        if (this.m_nameTextField != null) {
            this.m_nameTextField.removeAll();
            this.m_nameTextField = null;
        }
        if (this.m_queueComboBox != null) {
            this.m_queueComboBox.removeAllItems();
            this.m_queueComboBox = null;
        }
        if (this.m_descriptionTextArea != null) {
            this.m_descriptionTextArea.removeAll();
            this.m_descriptionTextArea = null;
        }
        this.m_workBasketWizard = null;
        this.m_selectedQueueDef = null;
        this.removeAll();
    }

    public boolean getDisplayState() {
        return true;
    }

    public void setDisplayState(boolean bState) {
    }

    public boolean getEnableFinishButton() {
        return false;
    }

    private void createControls(VWQueueDefinition[] queueDefs) {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            this.add((Component)this.getNamePanel(), gbCons);
            ++gbCons.gridx;
            this.add((Component)this.getQueuePanel(queueDefs), gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.gridwidth = 0;
            this.add((Component)this.getDescriptionPanel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getNamePanel() {
        try {
            JPanel namePanel = new JPanel(new BorderLayout(3, 3));
            JLabel workBasketNameLabel = new JLabel(VWResource.Colon.toString(VWResource.Name));
            VWAccessibilityHelper.setAccessibility(workBasketNameLabel, this, VWResource.Name, VWResource.Name);
            namePanel.add((Component)workBasketNameLabel, "First");
            this.m_nameTextField = new JTextField();
            VWAccessibilityHelper.setAccessibility(this.m_nameTextField, this, VWResource.InbasketNameTextField, VWResource.InbasketNameTextField);
            VWAccessibilityHelper.setLabelFor(workBasketNameLabel, this.m_nameTextField);
            namePanel.add((Component)this.m_nameTextField, "Center");
            return namePanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getQueuePanel(VWQueueDefinition[] queueDefs) {
        try {
            JPanel queuePanel = new JPanel(new BorderLayout(3, 3));
            JLabel queueNameLabel = new JLabel(VWResource.Colon.toString(VWResource.Queue));
            VWAccessibilityHelper.setAccessibility(queueNameLabel, this, VWResource.Queue, VWResource.Queue);
            queuePanel.add((Component)queueNameLabel, "First");
            this.m_queueComboBox = new JComboBox<VWQueueDefinition>(queueDefs);
            this.m_queueComboBox.setRenderer(new VWLabelListCellRenderer());
            VWAccessibilityHelper.setAccessibility(this.m_queueComboBox, this, VWResource.QueueComboBox, VWResource.QueueComboBox);
            VWAccessibilityHelper.setLabelFor(queueNameLabel, this.m_queueComboBox);
            queuePanel.add((Component)this.m_queueComboBox, "Center");
            return queuePanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getDescriptionPanel() {
        try {
            JPanel descriptionPanel = new JPanel(new BorderLayout(3, 3));
            JLabel descriptionLabel = new JLabel(VWResource.Colon.toString(VWResource.Description));
            descriptionPanel.add((Component)descriptionLabel, "First");
            this.m_descriptionTextArea = new JTextArea();
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            this.m_descriptionTextArea.setRows(5);
            descriptionPanel.add((Component)new JScrollPane(this.m_descriptionTextArea), "Center");
            VWAccessibilityHelper.setAccessibility(descriptionLabel, descriptionPanel, VWResource.Description, VWResource.Description);
            VWAccessibilityHelper.setAccessibility(this.m_descriptionTextArea, descriptionPanel, VWResource.Description, VWResource.Description);
            VWAccessibilityHelper.setLabelFor(descriptionLabel, this.m_descriptionTextArea);
            descriptionLabel.setLabelFor(this.m_descriptionTextArea);
            return descriptionPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void createWorkBasket() throws VWException {
        String workBasketName = this.m_nameTextField.getText();
        if (workBasketName == null || workBasketName.length() == 0) {
            throw new VWException("vw.toolkit.admin.property.queue.NameCanNotBeNull", "Name cannot be null or empty.");
        }
        this.m_selectedQueueDef = (VWQueueDefinition)this.m_queueComboBox.getSelectedItem();
        if (this.m_selectedQueueDef == null) {
            throw new VWException("vw.toolkit.admin.property.queue.MustSelectAQueue", "You must select a queue.");
        }
        this.m_selectedQueueDef = (VWQueueDefinition)this.m_selectedQueueDef.clone();
        if (this.m_workBasketDef != null && VWStringUtils.compare(this.m_workBasketDef.getQueueName(), this.m_selectedQueueDef.getName()) == 0) {
            if (VWStringUtils.compare(this.m_workBasketDef.getName(), workBasketName) == 0) {
                this.m_workBasketDef.setName(workBasketName);
            }
        } else {
            this.m_workBasketDef = this.m_selectedQueueDef.createWorkBasketDefinition(workBasketName);
        }
        this.m_workBasketDef.setDescription(this.m_descriptionTextArea.getText());
        this.m_workBasketWizard.setQueueDefinition(this.m_selectedQueueDef);
        this.m_workBasketWizard.setWorkBasketDefinition(this.m_workBasketDef);
    }
}

